#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <stdlib.h>

#include "delay_4m.h"
#include "glcd.h"
#include "i2c.h"
#include "adc.h"

//#define DEBUGGER
#define EP 0xA0
#define DEC 10
#define ON 1
#define OFF 0

	void CreateScreen(void);
	void PanelInit(void);
	void volplus(unsigned char val );
	void volminus( unsigned char val);
	void loadDefault(void);
	void readValue(void);
	void printVolume(void);
	void saveData(void);

	struct font LF, SF;
	unsigned char volume;
	unsigned char ballance;
	unsigned char mutte;
	unsigned char temp;
	unsigned char input;
	unsigned char on_delay;
	unsigned char off_delay;
	unsigned char eepstatus;
	unsigned char Amplifier;

int main(void) {

	LF.width = FONT12X16_WIDTH;
	LF.height = FONT12X16_HEIGHT;
	LF.charData = Font12x16;
	
	SF.width = FONT6X8_WIDTH;
	SF.height = FONT6X8_HEIGHT;
	SF.charData = Font6x8;

	delay_1ms(500);

	PanelInit();	

	PrintAt (  0,  4, "QUAD 405"   , LF );
	PrintAt ( 10, 28, "inditas....", SF );
	
	readValue();
	CreateScreen();
	delay_1ms( on_delay );
	PORTC |= (1 << PC2);	
	volplus( volume );
	while(1)
	{
		ks0108SetDot(2,2);
		delay_1ms(1000);
		ks0108ClearDot(2,2);
		delay_1ms(1000);
	};
}

void PanelInit(void)
{
//**********Perifériák inicializálása**************
	ks0108Init();
	i2cInit();		
	adcInit();

	//PORTA
	DDRA &= 0x00;		//PA0 - PA2 Analog bemenetek,  PA3-PA4 Bementválasztó kimenet, PA5-PA7 hangerőállítás
	DDRA |= 0xF8;
	PORTA &= 0x00;

	DDRC |= ( 1 << PC2 );	//2-es relé vez.
	PORTC &= ( 0  << PC2 );
	//PORTD
	DDRD &= 0x00;
	DDRD |= 0x8A;
	DDRD &= (0<<PD4);
	DDRD &= (0<<PD5);
	DDRD &= (0<<PD6);
	DDRD |= (1<<PD3);
	//DDRD &= (0 << PD2 );
	PORTD &= 0x00;

	sei();	
	GICR |= (1<<INT0);
};
void loadDefault(void)
{
	i2cSend( EP, 3000, 0);
	i2cSend( EP, 3001,128);
	i2cSend( EP, 3002,10);
	i2cSend( EP, 3003,60);
	i2cSend( EP, 3004,0);
	i2cSend( EP, 3005,3);
	i2cSend( EP, 3006,0);	
	i2cSend( EP, 3007,1);

	volume = 0;
	ballance = 128;
	mutte = 10;
	temp = 60;
	input = 0;
	on_delay = 3;
	off_delay = 3;
};


void readValue(void)
{
	eepstatus = i2cRec(EP,3007);		
	if (eepstatus == 1 )
	{
	
			volume = i2cRec(EP,3000);
			ballance = i2cRec(EP,3001);	
			mutte =	i2cRec(EP,3002);	
			temp = i2cRec(EP,3003);	
			input = i2cRec(EP,3004);	
			on_delay = i2cRec(EP,3005);	
			off_delay = i2cRec(EP,3006);				
	}
	else loadDefault();
};

void CreateScreen(void)
{	
	char *text;
	
	GlcdClear();
	PrintAt(10,23, "QUAD 405", LF);
	
	if (input == 0) text = "Line1";
	if (input == 1) text = "Line2";
	if (input == 2) text = "Line3";
	if (input == 3) text = "Line4";
	PrintAt(4,55, text , SF);
	printVolume();
	
		
};

void printVolume(void)
{
	char *text;

	itoa(volume, text, DEC);
	PrintAt(4,5, "Volume: ", SF );
	PrintAt(48,5, text, SF );
};

void EEPrint( unsigned int cim, unsigned char inv )
{
	cim = ( cim * 8) + 1;
	unsigned char temp;
	unsigned int i;

	for ( i = cim; i< cim + 8; i++)
	{
		temp = i2cRec( EP , i );
		ks0108WriteData( temp );
	};
};

void volplus(unsigned char val)
{
	unsigned char i;
	for ( i = 0; i< val; i++)	
		{
			if (volume < 64){
				PORTA |= (1 << PA5);
				delay_1ms(10);
				PORTA &= (0 << PA5);
				volume = volume + 1;
			};
		};
	
};

void volminus(unsigned char val)
{
	unsigned char i;
	for ( i = 0; i< val; i++)	
		{	
			if( volume > 0 ){
				PORTA |= (1 << PA6);
				delay_1ms(10);
				PORTA &= (0 << PA6);
				volume = volume - 1;
			};
		};
	
};

void saveData(void)
{
	i2cSend( EP, 3000, volume);
	i2cSend( EP, 3001, ballance);
	i2cSend( EP, 3002, mutte);
	i2cSend( EP, 3003, temp);
	i2cSend( EP, 3004, input);
	i2cSend( EP, 3005, on_delay);
	i2cSend( EP, 3006, off_delay);	
	i2cSend( EP, 3007, 1);
};


SIGNAL( SIG_INTERRUPT0)
{
	unsigned char key;
	key = PIND & 0x70;
	char *text;
#ifdef DEBUGGER
	
	itoa(key, text, DEC);
	PrintAt(60,55, text, SF);
#endif	

	if (key == 16) {
		if (Amplifier == ON ){
			PORTC &= ( 0 << PC2);			//hanhgszóróvédő relé
			delay_1ms(1000 * off_delay);
			PORTD |= ( 1 << PD3);			//hattérvil
			PORTD &= ( OFF << PD7);			//taprelé
			saveData();
		};
		if (Amplifier == OFF) {
			readValue();
			PORTD |= ( ON  << PD7);			//taprelé
			PORTD |= ( 1 << PD3);			//hattérvil
			delay_1ms( 1000 * on_delay);
			PORTC |= ( 1 << PC2);			//hangszóróvédő relé
	
			
		};
	};
	
	if (key == 32) {
		volplus (1);
		printVolume();
	};
	if (key == 48) {
		volminus(1);
		printVolume();
	};
	if (key == 64){

		uint8_t _inp;		
		++input;

		if (input == 4) input = 0;
	
		if (input == 0) {
			text = "Line1";
			PORTA &= 0xE7;			//a bementváltót nullára állítja
		}
		if (input == 1) {
			text = "Line2";
			PORTA &= 0xE7;			//bemenetváltó 0
			PORTA |= (1 << PA3);		//bementváltó1
		}
		if (input == 2) {
			text = "Line3";
			PORTA &= 0xE7;			//bemenetváltó 0
			PORTA |= (1 << PA4);		//bem 2
		}
		if (input == 3) {
			text = "Line4";
			PORTA &= 0xE7;			//bem 0
			PORTA |= (1 << PA3);		//bem 3
			PORTA |= (1 << PA4);
		}
		
		PrintAt(4,55, text , SF);
		delay_1ms(500);	
	};

#ifdef DEBUGGER
	delay_1ms(500);	
#endif
};